package gov.va.genisis2.ts.dto;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SearchResultDTO implements Serializable {

	private static final long serialVersionUID = 6486930749651879622L;

	private String conceptName;
	private String conceptUri;
	private String definition;

	public SearchResultDTO(SolrDocDTO solrDocDto) {
		super();
		conceptName = solrDocDto.getLabel();
		conceptUri = solrDocDto.getId();
		definition = solrDocDto.getDefinition();
	}


	/**
	 * @return the conceptName
	 */
	public String getConceptName() {
		return conceptName;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setConceptName(String name) {
		this.conceptName = name;
	}

	/**
	 * @return the conceptUri
	 */
	public String getConceptUri() {
		return conceptUri;
	}

	/**
	 * @param uri
	 *            the uri to set
	 */
	public void setConceptUri(String uri) {
		this.conceptUri = uri;
	}

	/**
	 * @return the definition
	 */
	public String getDefinition() {
		return definition;
	}

	/**
	 * @param definition
	 *            the definition to set
	 */
	public void setDefinition(String definition) {
		this.definition = definition;
	}
}
